
lambdavec=0:360; len=length(lambdavec);% lambda=hour angle in degree; -0 at noon

alpha=1*23.5;% skewness earth axis (pos in boreal summer)
phi=50; %latitude in degree
for i=1:len
    
lambda=lambdavec(i); %hour angle in degree
  
sa=sin(alpha/180*pi);  ca=cos(alpha/180*pi);
sp=sin(phi/180*pi);    cp=cos(phi/180*pi);
sl=sin(lambda/180*pi); cl=cos(lambda/180*pi);

%coordinate system: x=towards sun, z=ecliptic, y=tangential to earth orbit
%(if spherical)
qv=[sa 0 ca]*sp +( [ca 0 -sa]*cl + [0 1 0]*sl)*cp; % unit vector pointing upwards 
qe=             -  [ca 0 -sa]*sl + [0 1 0]*cl    ; % unit vector pointing eastwards
qn=[sa 0 ca]*cp -( [ca 0 -sa]*cl + [0 1 0]*sl)*sp; % unit vector pointing northwards

%the x-omponent of these vectors is the projection of the sun's direction
%([1 0 0]) onto upwards etc directions
hv=acos(qv(1))*180/pi; %angle of the sun with the vertical
he=acos(qe(1))*180/pi;
hn=acos(qn(1))*180/pi;

%now the direction wherein the sun is found (w.r.t south)
beta=atan(qe(1)/qn(1))*180/pi*1; 
beta=mod(beta,360);


betavec(i)=beta;
hvvec(i)=hv; hnvec(i)=hn; hevec(i)=he; 

end
fonty=21; %fontsize

% figure
% plot(lambdavec/15, hvvec)
% title(['vertical; alpha=', num2str(alpha) 'deg; phi=' num2str(phi) 'deg'])
% xlabel('time since noon in hours')
% ylabel('angle between sun and vertical in deg')
% 
% figure
% plot(lambdavec/15, hnvec)
% title(['north; alpha=', num2str(alpha) 'deg; phi=' num2str(phi) 'deg'])
% xlabel('time since noon in hours')
% ylabel('angle between sun and north in deg')
% 
% figure
% plot(lambdavec/15, hevec)
% title(['east; alpha=', num2str(alpha) 'deg; phi=' num2str(phi) 'deg'])
% xlabel('time since noon in hours')
% ylabel('angle between sun and east in deg')

jump=0;
for i=2:len;
betavec(i)=betavec(i)-180*round((betavec(i)-betavec(i-1))/180);
end
    
    
figure
set(gca,'FontSize',fonty)
plot(lambdavec/15, betavec)
hold on
plot(lambdavec/15, (0:len-1)*360/(len-1),'r')
title(['angle sun w.r.t. south; alpha=', num2str(alpha) 'deg; phi=' num2str(phi) 'deg'],'FontSize',fonty)
xlabel('time since noon in hours','FontSize',fonty)
ylabel('angle sun w.r.t. south','FontSize',fonty)